<?php

require_once '../model/database.php';
require_once '../model/product_model.php';
require_once 'header.php';

if (isset($_GET['product_id'])) {
    $prod_id = $_GET['product_id'];
    $product = get_product_by_id($conn, $prod_id);

    if ($product) {
        echo "<h1>Product Details</h1>";
        echo "<nav><a href='../index.php'>Home</a> | <a href='product_info.php'>Product Info</a> | <a href='manage_products.php'>Products</a></nav>";

        // Mapping field names to human-readable labels
        $labels = [
            'prod_id' => 'Product ID',
            'prod_name' => 'Product Name',
            'prod_price' => 'Product Price',
            'prod_desc' => 'Product Description',
            'vend_name' => 'Vendor Name',  // Added vendor name mapping
        ];

        echo "<table border='1' cellpadding='5'>";
        
        // Table header (across the top)
        echo "<thead><tr>";
        foreach ($labels as $label) {
            echo "<th>$label</th>";
        }
        echo "</tr></thead>";

        // Table body (product details)
        echo "<tbody><tr>";
        foreach ($product as $key => $value) {
            // Use the label from the mapping array or the key itself if not found in the labels array
            $label = isset($labels[$key]) ? $labels[$key] : ucfirst(str_replace('_', ' ', $key));
            echo "<td>" . htmlspecialchars($value) . "</td>";
        }
        echo "</tr></tbody>";
        
        echo "</table>";
    } else {
        echo "<p>Product not found.</p>";
    }
} else {
    echo "<p>Product ID not provided.</p>";
}

require_once 'footer.php';
?>
